// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'BRegExp.pas' rev: 6.00

#ifndef BRegExpHPP
#define BRegExpHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Windows.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Bregexp
{
//-- type declarations -------------------------------------------------------
typedef char * *PPChar;

#pragma pack(push, 1)
struct TBRegExpRec
{
	char *outp;
	char *outendp;
	int splitctr;
	char * *splitp;
	int rsv1;
	char *parap;
	char *paraendp;
	char *transtblp;
	char * *startp;
	char * *endp;
	int nparens;
} ;
#pragma pack(pop)

typedef TBRegExpRec *pTBRegExpRec;

class DELPHICLASS EBRegExpError;
class PASCALIMPLEMENTATION EBRegExpError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EBRegExpError(const AnsiString Msg) : Sysutils::Exception(Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EBRegExpError(const AnsiString Msg, const System::TVarRec * Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EBRegExpError(int Ident)/* overload */ : Sysutils::Exception(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EBRegExpError(int Ident, const System::TVarRec * Args, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EBRegExpError(const AnsiString Msg, int AHelpContext) : Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EBRegExpError(const AnsiString Msg, const System::TVarRec * Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EBRegExpError(int Ident, int AHelpContext)/* overload */ : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EBRegExpError(System::PResStringRec ResStringRec, const System::TVarRec * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EBRegExpError(void) { }
	#pragma option pop
	
};


#pragma option push -b-
enum TBRegExpMode { brxNone, brxMatch, brxSplit };
#pragma option pop

class DELPHICLASS TBRegExp;
class PASCALIMPLEMENTATION TBRegExp : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	AnsiString operator[](int index) { return Strings[index]; }
	
private:
	TBRegExpMode Mode;
	char *pTargetString;
	TBRegExpRec *pBRegExp;
	int __fastcall GetMatchPos(void);
	int __fastcall GetMatchLength(void);
	int __fastcall GetSplitCount(void);
	AnsiString __fastcall GetMatchStrings(int index);
	int __fastcall GetMatchCount(void);
	int __fastcall GetCount(void);
	AnsiString __fastcall GetStrings(int index);
	AnsiString __fastcall GetSplitStrings(int index);
	AnsiString __fastcall GetLastCommand();
	void __fastcall CheckCommand(const AnsiString Command);
	
public:
	__fastcall virtual ~TBRegExp(void);
	bool __fastcall Match(const AnsiString Command, const AnsiString TargetString);
	bool __fastcall Subst(const AnsiString Command, AnsiString &TargetString);
	bool __fastcall Split(const AnsiString Command, const AnsiString TargetString, int Limit);
	bool __fastcall Trans(const AnsiString Command, AnsiString &TargetString);
	__property AnsiString LastCommand = {read=GetLastCommand};
	__property int MatchPos = {read=GetMatchPos, nodefault};
	__property int MatchLength = {read=GetMatchLength, nodefault};
	__property int Count = {read=GetCount, nodefault};
	__property AnsiString Strings[int index] = {read=GetStrings/*, default*/};
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TBRegExp(void) : System::TObject() { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
static const Shortint BREGEXP_ERROR_MAX = 0x50;
extern PACKAGE bool __cdecl (*BMatch)(char * str, char * target, char * targetendp, pTBRegExpRec &rxp, char * msg);
extern PACKAGE bool __cdecl (*BSubst)(char * str, char * target, char * targetendp, pTBRegExpRec &rxp, char * msg);
extern PACKAGE bool __cdecl (*BTrans)(char * str, char * target, char * targetendp, pTBRegExpRec &rxp, char * msg);
extern PACKAGE bool __cdecl (*BSplit)(char * str, char * target, char * targetendp, int limit, pTBRegExpRec &rxp, char * msg);
extern PACKAGE void __cdecl (*BRegFree)(pTBRegExpRec rx);
extern PACKAGE char * __cdecl (*BRegExpVersion)(void);
extern PACKAGE unsigned hDLL;
extern PACKAGE TBRegExp* __fastcall brx(void);

}	/* namespace Bregexp */
using namespace Bregexp;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// BRegExp
