unit BRegExp;

//=====================================================================
// BRegExp.pas : Borland Delphi p BREGEXP.DLL pjbg
//               1998/10/03      osamu@big.or.jp
//
// BREGEXP.DLL ́Ahttp://www.hi-ho.or.jp/~babaq/ ɂČJĂ
// Perl5݊̐K\GW BREGEXP.DLL  Borland Delphi 痘p
// 邽߂̃jbgt@CłBDelphi 3 ō쐬܂A32bit
// ł Delphi  C++ Builder œ\Ǝv܂B
//
// BREGEXP.DLL ̗pȂǂ́Az[y[WQƉBLp
// Cu𖳏Œ񋟉Ă babaq ɊӂƂƂɁA
// ̂҂Ă܂B
//
// {jbg̒쌠ɂẮAƂ₩͂܂BD
// 悤ɂgBApɓĂ͂̐ӔC̉ɂ
// ܂B{jbgɊւ osamu@big.or.jp ͉ӔC𕉂Ƃ
// ̂Ƃ܂B
//
// {jbǵA DLL ƂƂɔzzĂwb_t@CyсALz[
// y[Wōsꂽ[UT|[g̃Ot@CƂɍ쐬܂B
// CÂ̓_Ȃǂ܂Aosamu@big.or.jp ܂œdq[ɂ
// m点΁ACł͂Ȃ炩̑Ώ\܂B(^_^;
//
// gp@ɂĂ͕t̃wvt@CB
//=====================================================================
//               2001/04/14      osamu@big.or.jp
// {Ƃ̃hLg̃o[WAbvɔoĂoOC
// brx ֐𓱓
// 󕶎ɑ΂錟̃G[
// MatchPos  1 琔n߂悤ɎdlύX
// Subst  Strings[] QƉ\ɂ
// ɔʂ̕ɑ΂u͒xȂ
//=====================================================================

interface

uses SysUtils,Windows;

//=====================================================================
// { BREGEXP.H ƁAT|[gz[y[W̃hLg
// BREGEXP.DLL ƒ錾
//=====================================================================

const
BREGEXP_ERROR_MAX= 80;  // G[bZ[W̍ő咷

type
PPChar=^PChar;
TBRegExpRec=packed record
    outp: PChar;        // uʐ擪|C^
    outendp: PChar;     // uʖ|C^
    splitctr: Integer;  // split ʃJE^
    splitp: PPChar;     // split ʃ|C^|C^
    rsv1: Integer;      // \ς
    parap: PChar;       // R}h擪|C^ ('s/xxxxx/yy/gi')
    paraendp: PChar;    // R}h񖖔|C^
    transtblp: PChar;   // tr e[uւ̃|C^
    startp: PPChar;     // }b`ւ̐擪|C^
    endp: PPChar;       // }b`ւ̖|C^
    nparens: Integer;   // match/subst ̊ʂ̐
end;
pTBRegExpRec=^TBRegExpRec;

{function BMatch(str, target, targetendp: PChar;
                var rxp: pTBRegExpRec; msg: PChar): Boolean; cdecl;
    external 'bregexp.dll';
function BSubst(str, target, targetendp: PChar;
                var rxp: pTBRegExpRec; msg: PChar): Boolean; cdecl;
    external 'bregexp.dll';
function BTrans(str, target, targetendp: PChar;
                var rxp: pTBRegExpRec; msg: PChar): Boolean; cdecl;
    external 'bregexp.dll';
function BSplit(str, target, targetendp: PChar; limit: Integer;
                var rxp: pTBRegExpRec; msg: PChar): Boolean; cdecl;
    external 'bregexp.dll';
procedure BRegFree(rx: pTBRegExpRec); cdecl;
    external 'bregexp.dll' name 'BRegfree';
function BRegExpVersion: PChar; cdecl;
    external 'bregexp.dll' name 'BRegexpVersion';}

//=====================================================================
// TBRegExp : BREGEXP.DLL ̋@\JvZIuWFNg
//=====================================================================

type
EBRegExpError=class(Exception) end;
TBRegExpMode=(brxNone, brxMatch, brxSplit);
TBRegExp=class(TObject)
  private
    Mode: TBRegExpMode;
    pTargetString: PChar;
    pBRegExp: PTBRegExpRec;
    function GetMatchPos: Integer;
    function GetMatchLength: Integer;
    function GetSplitCount: Integer;
    function GetMatchStrings(index:Integer): string;
    function GetMatchCount: Integer;
    function GetCount: Integer;
    function GetStrings(index: Integer): string;
    function GetSplitStrings(index: Integer): string;
    function GetLastCommand: string;
    procedure CheckCommand(const Command: string);
  public
    destructor Destroy; override;
  public
    function Match(const Command, TargetString: string): Boolean;
    function Subst(const Command: string; var TargetString: string): Boolean;
    function Split(const Command, TargetString: string; Limit: Integer): Boolean;
    function Trans(const Command: string;var TargetString: string): Boolean;
    property LastCommand: string read GetLastCommand;
    property MatchPos: Integer read GetMatchPos;
    property MatchLength: Integer read GetMatchLength;
    property Count: Integer read GetCount;
    property Strings[index: Integer]: string read GetStrings; default;
end;

//=====================================================================
// IɎ̉Aj郆[eBeBCX^X
//=====================================================================

function brx: TBRegExp;
var
BMatch:function (str, target, targetendp: PChar;
                var rxp: pTBRegExpRec; msg: PChar): Boolean;cdecl;
BSubst:function (str, target, targetendp: PChar;
                var rxp: pTBRegExpRec; msg: PChar): Boolean;cdecl;
BTrans:function (str, target, targetendp: PChar;
                var rxp: pTBRegExpRec; msg: PChar): Boolean;cdecl;
BSplit:function (str, target, targetendp: PChar; limit: Integer;
                var rxp: pTBRegExpRec; msg: PChar): Boolean;cdecl;
BRegFree:procedure (rx: pTBRegExpRec);cdecl;
BRegExpVersion:function : PChar; cdecl;{cdecl;}
hDLL:THandle;

//=====================================================================

implementation

//=====================================================================

var fbrx: TBRegExp;

function brx: TBRegExp;
begin
 if fbrx=nil then fbrx:=TBRegExp.Create;
  Result:=fbrx;
end;

//=====================================================================

destructor TBRegExp.Destroy;
begin
   if pBRegExp<>nil then
        BRegFree(pBRegExp);
{    FreeLibrary(hDLL);}
    inherited Destroy;
end;

//=====================================================================
// ÕR}hԂ

function TBRegExp.GetLastCommand: string;
var len: Integer;
begin
    if pBRegExp=nil then begin
        Result:= '';
    end else begin
        len:= Integer(pBRegExp^.paraendp)-Integer(pBRegExp^.parap);
        SetLength(Result, len);
        Move(pBRegExp^.parap^, Result[1], len);
    end;
end;

//=====================================================================
// OƈقȂR}hł΃LbVNA葱

procedure TBRegExp.CheckCommand(const Command: string);
var p,q: PChar;
begin
    if pBRegExp=nil then Exit;
    p:= pBRegExp.parap - 1;
    q:= PChar(@Command[1]) - 1;
    repeat
        Inc(p);
        Inc(q);
        if p^<>q^ then begin
            BRegFree(pBRegExp);
            pBRegExp:= nil;
            Break;
        end;
    until p^=#0;
end;

//=====================================================================

function TBRegExp.Match(const Command, TargetString: string): Boolean;
var ErrorString: string;
    i: Integer;
begin
    CheckCommand(Command);
    SetLength(ErrorString, BREGEXP_ERROR_MAX);
    Mode:=brxNone;
    if TargetString='' then begin // G[
        i:=0;
        Result:=BMatch(
            PChar(Command),
            PChar(@i),
            PChar(@i)+1,    
            pBRegExp,
            PChar(ErrorString));
    end else begin
        Result:=BMatch(
            PChar(Command),
            PChar(TargetString),
            PChar(TargetString)+Length(TargetString),
            pBRegExp,
            PChar(ErrorString));
    end;
    SetLength(ErrorString, StrLen(PChar(ErrorString)));
    if ErrorString<>'' then
        raise EBRegExpError.Create(ErrorString);
    if Result then Mode:= brxMatch;
    pTargetString:= PChar(TargetString);
end;

//=====================================================================

function TBRegExp.Subst(const Command: string;
                        var TargetString: string): Boolean;
var ErrorString: string;
TextBuffer: string;
    ep,sp: PPChar;
    i: Integer;
begin
    CheckCommand(Command);
    Result:=False;
    if TargetString='' then Exit;
    TextBuffer:= TargetString;  // ( ) 𐳂Ԃ߂ɃeLXgۑ
    UniqueString(TextBuffer);
    SetLength(ErrorString, BREGEXP_ERROR_MAX);
    Mode:=brxNone;
    Result:=BSubst(
        PChar(Command),
        PChar(TargetString),
        PChar(TargetString)+Length(TargetString),
        pBRegExp,
        PChar(ErrorString));
    SetLength(ErrorString,StrLen(PChar(ErrorString)));
    if ErrorString<>'' then
        raise EBRegExpError.Create(ErrorString);

    if Result then begin // ( ) ̌ʂ𐳂Ԃ
        sp:=pBRegExp^.startp;
        ep:=pBRegExp^.endp;
        for i:=0 to GetMatchCount-1 do begin
            Inc(ep^, Integer(TextBuffer)-Integer(TargetString));
            Inc(sp^, Integer(TextBuffer)-Integer(TargetString));
            Inc(sp);
            Inc(ep);
        end;
        TargetString:= pBRegExp^.outp;
        Mode:=brxMatch;
    end;
end;

//=====================================================================

function TBRegExp.Trans(const Command: string;
                        var TargetString: string): Boolean;
var ErrorString: string;
begin
    CheckCommand(Command);
    Mode:=brxNone;
    if TargetString='' then // G[
        TargetString:= #0;
    SetLength(ErrorString, BREGEXP_ERROR_MAX);
    Result:=BTrans(
        PChar(Command),
        PChar(TargetString),
        PChar(TargetString)+Length(TargetString),
        pBRegExp,
        PChar(ErrorString));
    SetLength(ErrorString,StrLen(PChar(ErrorString)));
    if ErrorString<>'' then
        raise EBRegExpError.Create(ErrorString);
    if Result then TargetString:=pBRegExp^.outp;
end;

//=====================================================================

function TBRegExp.Split(const Command, TargetString: string;
                        Limit: Integer): Boolean;
var ErrorString: string;
    t: string;
begin
    CheckCommand(Command);
    SetLength(ErrorString, BREGEXP_ERROR_MAX);
    Mode:=brxNone;
    if TargetString='' then begin // G[
        t:= #0;
        Result:=BSplit(
            PChar(Command),
            PChar(t),
            PChar(t)+1,
            Limit,
            pBRegExp,
            PChar(ErrorString));
    end else begin
        Result:=BSplit(
            PChar(Command),
            PChar(TargetString),
            PChar(TargetString)+Length(TargetString),
            Limit,
            pBRegExp,
            PChar(ErrorString));
    end;
    SetLength(ErrorString,StrLen(PChar(ErrorString)));
    if ErrorString<>'' then
        raise EBRegExpError.Create(ErrorString);
    Mode:=brxSplit;
end;

//=====================================================================

function TBRegExp.GetMatchPos: Integer;
begin
    if Mode<>brxMatch then
        raise EBRegExpError.Create('no match pos');
    Result:=Integer(pBRegExp.startp^)-Integer(pTargetString)+1;
end;

//=====================================================================

function TBRegExp.GetMatchLength: Integer;
begin
    if Mode<>brxMatch then
        raise EBRegExpError.Create('no match length');
    Result:=Integer(pBRegExp.endp^)-Integer(pBRegExp.startp^);
end;

//=====================================================================

function TBRegExp.GetCount: Integer;
begin
    Result:=0;
    case Mode of
    brxNone:
        raise EBRegExpError.Create('no count now');
    brxMatch:
        Result:=GetMatchCount;
    brxSplit:
        Result:=GetSplitCount;
    end;
end;

//=====================================================================

function TBRegExp.GetMatchCount: Integer;
begin
    Result:= pBRegExp^.nparens+1;
end;

//=====================================================================

function TBRegExp.GetSplitCount: Integer;
begin
    Result:=pBRegExp^.splitctr;
end;

//=====================================================================

function TBRegExp.GetStrings(index: Integer): string;
begin
    Result:='';
    case Mode of
    brxNone:
        raise EBRegExpError.Create('no strings now');
    brxMatch:
        Result:=GetMatchStrings(index);
    brxSplit:
        Result:=GetSplitStrings(index);
    end;
end;

//=====================================================================

function TBRegExp.GetMatchStrings(index:Integer):string;
var sp,ep: PPChar;
begin
    Result:='';
    if (index<0) or (index>=GetMatchCount) then
        raise EBRegExpError.Create('index out of range');
    sp:=pBRegExp^.startp; Inc(sp, index);
    ep:=pBRegExp^.endp;   Inc(ep, index);
    SetLength(Result,Integer(ep^)-Integer(sp^));
    Move(sp^^,PChar(Result)^,Integer(ep^)-Integer(sp^));
end;

//=====================================================================

function TBRegExp.GetSplitStrings(index:Integer): string;
var p: PPChar;
    sp,ep: PChar;
begin
    if (index<0) or (index>=GetSplitCount) then
        raise EBRegExpError.Create('index out of range');
    p:=pBRegExp^.splitp;
    Inc(p,index*2); sp:=p^;
    Inc(p);         ep:=p^;
    SetLength(Result,Integer(ep)-Integer(sp));
    Move(sp^,PChar(Result)^,Integer(ep)-Integer(sp));
end;

//=====================================================================

initialization
 hDLL := LoadLibrary('BREGEXP.DLL');
  if hDLL = 0 then
    raise Exception.Create('BREGEXP.DLL̃[hɎs'#$d#$a'G[R[h=' +IntToStr(GetLastError));
  @BMatch:= GetProcAddress(hDLL,'BMatch');
  @BSubst:= GetProcAddress(hDLL,'BSubst');
  @BTrans:= GetProcAddress(hDLL,'BTrans');
  @BSplit:= GetProcAddress(hDLL,'BSplit');
  @BRegFree:= GetProcAddress(hDLL,'BRegfree');
  @BRegExpVersion:= GetProcAddress(hDLL,'BRegexpVersion');

finalization
  fbrx.Free;
  FreeLibrary(hDLL);
end.

